<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class RuleLimit extends Model 
{

    protected $table = 'rule_limits';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('type', 'limit', 'day', 'hour', 'campaign_period', 'rule_main_id');

    public function ruleMain()
    {
        return $this->hasOne('App\Models\RuleMain', 'rule_main_id');
    }

}